% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScatterSamples.R
\name{ScatterSamples}
\alias{ScatterSamples}
\title{Scatterplots of samples}
\usage{
ScatterSamples(Sampling, SampleNames, SelectedSamples, sc = 3,
  Nb_chaines = 3)
}
\arguments{
\item{Sampling}{MCMC.list: that is generated by \code{\link{jags.model}} in \code{\link{AgeS_Computation}},
\code{\link{AgeC14_Computation}} or \code{\link{Age_OSLC14}}.}

\item{SampleNames}{character vector: names of samples.}

\item{SelectedSamples}{numeric vector: indicate if the sample is selected to be plot with the other samples.
If the sample with names \code{SampleNames[i]} is selecteted, then \code{SelectedSamples[i]=1}; if not \code{SelectedSamples=0}.
\code{length(SelectedSamples)}=\code{length(SampleNames)}.
At least two samples must be selected.}

\item{sc}{numeric (with default): to define the number of values on the axis.}

\item{Nb_chaines}{integer (with default): number of independent chains used in \code{\link{AgeS_Computation}}
to generate the sampling (for more information see \code{\link{jags.model}}).}
}
\value{
A matrix that contains at row \code{i} and column \code{j} the scatterplot of the posterior distribution of
the sample ID \code{i} plotted against the one of the sample ID \code{j}
}
\description{
This fonction compute a matrix of scatterplots of at most 8 samples.
}
\examples{
data(AgeS,envir = environment())
ScatterSamples(Sampling=AgeS$Sampling,SampleNames=c("GDB5","GDB3"),SelectedSamples=c(1,1))

}
\seealso{
\code{\link{Age_Computation}}, \code{\link{AgeS_Computation}}, \code{\link{AgeC14_Computation}},
and \code{\link{rjags}} packages.
}
\author{
Claire Christophe, Anne Philippe, Guillaume Guerin
}
