% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{add_relations}
\alias{add_relations}
\title{Add relations to a TidySet}
\usage{
add_relations(object, elements, sets, fuzzy, ...)
}
\arguments{
\item{object}{A \code{\link{TidySet}} object}

\item{elements}{A character vector of the elements.}

\item{sets}{A character vector of sets to be added.}

\item{fuzzy}{The strength of the membership.}

\item{...}{Placeholder for other arguments that could be passed to the
method. Currently not used.}
}
\value{
A \code{\link{TidySet}} object with the new relations.
}
\description{
Adds new relations to existing or new sets and elements.
If the sets or elements do not exist they are added.
}
\note{
\code{add_relations} doesn't set up any other information about the
relationship.
Remember to add/modify them if needed with \code{\link{mutate}} or \code{\link{mutate_relation}}
}
\examples{
x <- list("a" = letters[1:5], "b" = LETTERS[3:7])
a <- tidySet(x)
add_relations(a, elements = c("a", "b", "g"), sets = "d")
add_relations(a, elements = c("a", "b"), sets = c("d", "g"))
add_relations(a, elements = c("a", "b"), sets = c("d", "g"), fuzzy = 0.5)
add_relations(a,
    elements = c("a", "b"), sets = c("d", "g"),
    fuzzy = c(0.5, 0.7)
)
}
\seealso{
\code{\link{add_relation}} to add relations with new sets or/and
new elements.

Other add_*: 
\code{\link{add_elements}()},
\code{\link{add_sets}()}
}
\concept{add_*}
