% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complement.R
\name{complement}
\alias{complement}
\title{Complement TidySet}
\usage{
complement(.data, ...)
}
\arguments{
\item{.data}{The TidySet object}

\item{...}{Other arguments passed to either \code{\link{complement_set}} or
\code{\link{complement_element}}.}
}
\value{
A TidySet object
}
\description{
Use complement to find elements or sets the TidySet object. You can use
activate with complement or use the specific function. You must specify if
you want the complements of sets or elements.
}
\examples{
rel <- data.frame(
    sets = c("A", "A", "B", "B", "C", "C"),
    elements = letters[seq_len(6)],
    fuzzy = runif(6)
)
TS <- tidySet(rel)
TS \%>\%
    activate("elements") \%>\%
    complement("a")
TS \%>\%
    activate("elements") \%>\%
    complement("a", "C_a", keep = FALSE)
TS \%>\%
    activate("set") \%>\%
    complement("A")
TS \%>\%
    activate("set") \%>\%
    complement("A", keep = FALSE)
TS \%>\%
    activate("set") \%>\%
    complement("A", FUN = function(x){abs(x - 0.2)}, keep = FALSE)
}
\seealso{
\code{\link{activate}}

Other complements: 
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{subtract}()}

Other methods: 
\code{\link{TidySet-class}},
\code{\link{activate}()},
\code{\link{add_column}()},
\code{\link{add_relation}()},
\code{\link{arrange.TidySet}()},
\code{\link{cartesian}()},
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{element_size}()},
\code{\link{elements}()},
\code{\link{filter.TidySet}()},
\code{\link{group_by.TidySet}()},
\code{\link{group}()},
\code{\link{incidence}()},
\code{\link{intersection}()},
\code{\link{is.fuzzy}()},
\code{\link{is_nested}()},
\code{\link{move_to}()},
\code{\link{mutate.TidySet}()},
\code{\link{nElements}()},
\code{\link{nRelations}()},
\code{\link{nSets}()},
\code{\link{name_elements<-}()},
\code{\link{name_sets<-}()},
\code{\link{name_sets}()},
\code{\link{power_set}()},
\code{\link{pull.TidySet}()},
\code{\link{relations}()},
\code{\link{remove_column}()},
\code{\link{remove_element}()},
\code{\link{remove_relation}()},
\code{\link{remove_set}()},
\code{\link{rename_elements}()},
\code{\link{rename_set}()},
\code{\link{select.TidySet}()},
\code{\link{set_size}()},
\code{\link{sets}()},
\code{\link{subtract}()},
\code{\link{union}()}
}
\concept{complements}
\concept{methods}
