% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Wastewat}
\alias{Wastewat}
\title{Volume of injected waste water from Rocky Mountain Arsenal and number of
earthquakes near Denver}
\format{A data frame/tibble with 44 observations on two variables
\describe{ 
\item{gallons}{injected water (in million gallons)} 
\item{number}{number of earthqueakes detected in Denver}
}}
\source{
Davis, J. C. (1986), \emph{Statistics and Data Analysis in Geology}, 2 ed., John Wiley and Sons,
New York, p. 228, and Bardwell, G. E. (1970), Some Statistical Features of the Relationship between
Rocky Mountain Arsenal Waste Disposal and Frequency of Earthquakes, \emph{Geological Society of America, Engineering
Geology Case Histories, 8}, 33-337.
}
\usage{
Wastewat
}
\description{
Data for Exercise 9.18
}
\examples{

plot(number ~ gallons, data = Wastewat)
model <- lm(number ~ gallons, data = Wastewat)
summary(model)
anova(model)
plot(model, which = 2)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
