% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Stamp}
\alias{Stamp}
\title{Thicknesses of 1872 Hidalgo stamps issued in Mexico}
\format{A data frame/tibble with 485 observations on one variable
\describe{ 
\item{thickness}{stamp thickness (in mm)}
}}
\source{
Izenman, A., Sommer, C. (1988), Philatelic Mixtures and Multimodal Densities,
\emph{Journal of the American Statistical Association}, 83, 941-953.
}
\usage{
Stamp
}
\description{
Data for Statistical Insight Chapter 1 and Exercise 5.110
}
\examples{

hist(Stamp$thickness, freq = FALSE, col = "lightblue", 
     main = "", xlab = "stamp thickness (mm)")
lines(density(Stamp$thickness), col = "blue")
t.test(Stamp$thickness, conf.level = 0.99)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
