% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_contests.R
\name{comparisons_to_matrix}
\alias{comparisons_to_matrix}
\title{Construct Win Matrix from Comparisons}
\usage{
comparisons_to_matrix(n.areas, comparisons)
}
\arguments{
\item{n.areas}{The number of areas in the study.}

\item{comparisons}{An N x 2 data frame, where N is the number of comparisons. Each row should correspond to a judgment. The first column is the winning area, the second column is the more losing area. The areas should be labeled from 1 to n.areas.}
}
\value{
A matrix where the {i, j}^th element is the number of times area i beat area j.
}
\description{
This function constructs a win matrix from a data frame of comparisons. It is needed for the MCMC functions.
}
\examples{

#Generate some sample comparisons
comparisons <- data.frame("winner" = c(1, 3, 2, 2), "loser" = c(3, 1, 1, 3))

#Create matrix from comparisons
win.matrix <- comparisons_to_matrix(3, comparisons)

}
