% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/next.comb.R
\name{next.comb}
\alias{next.comb}
\title{Determine the dose combination for the next cohort of new patients for drug-combination trials that aim to find a MTD}
\usage{
next.comb(target, npts, ntox, dose.curr, n.earlystop=100,
                 p.saf="default", p.tox="default", cutoff.eli=0.95,
                 extrasafe=FALSE, offset=0.05)
}
\arguments{
\item{target}{the target toxicity rate}

\item{npts}{a \code{J*K} matrix \code{(J<=K)} containing the number of patients treated at each dose combination}

\item{ntox}{a \code{J*K} matrix \code{(J<=K)} containing the number of patients experienced
dose-limiting toxicity at each dose combination}

\item{dose.curr}{the current dose combination}

\item{n.earlystop}{the early stopping parameter. If the number of patients
treated at the current dose reaches \code{n.earlystop},
stop the trial and select the MTD based on the observed data.
The default value \code{n.earlystop=100} essentially turns
off this type of early stopping.}

\item{p.saf}{the highest toxicity probability that is deemed subtherapeutic
(i.e. below the MTD) such that dose escalation should be undertaken.
The default value is \code{p.saf=0.6*target}.}

\item{p.tox}{the lowest toxicity probability that is deemed overly toxic such
that deescalation is required. The default value is \code{p.tox=1.4*target}.}

\item{cutoff.eli}{the cutoff to eliminate an overly toxic dose for safety.
We recommend the default value of (\code{cutoff.eli=0.95})
for general use.}

\item{extrasafe}{set \code{extrasafe=TRUE} to impose a more stringent stopping rule}

\item{offset}{a small positive number (between 0 and 0.5) to control how strict the
              stopping rule is when \code{extrasafe=TRUE}. A larger value leads to a more
              strict stopping rule. The default value \code{offset=0.05} generally works well.}
}
\value{
the dose for treating the next cohort of new patients.
}
\description{
Determine the dose combination for the next cohort of new patients for drug-combination trials that aim to find a MTD
}
\details{
This function is used to determine dose combination for conducting combination trials.
         Given the currently observed data, \code{next.comb()} determines dose combination for
         treating the next cohort of new patients. The currently observed data include: the
         number of patients treated at each dose combination (i.e., \code{npts}),
         the number of patients who experienced dose-limiting toxicities at each dose
         combination (i.e.,\code{ntox}), and the level of current dose (i.e., \code{dose}).
}
\examples{
# make the decision of dose escalation/deescalation during the course of trial conduct
# matrix n contains the number of patients treated at each dose combination
# matrix y contains the number of patients experienced toxicity at each dose combination
n<-matrix(c(3, 0, 0, 0, 0, 7, 6, 0, 0, 0, 0, 0, 0, 0, 0), ncol=5, byrow=TRUE)
y<-matrix(c(0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0), ncol=5, byrow=TRUE)
next.comb(target=0.3, npts=n, ntox=y, dose.curr=c(2, 2))
}
\author{
Suyu Liu and Ying Yuan
}
\references{
Liu S. and Yuan, Y. (2015). Bayesian Optimal Interval Designs for Phase I Clinical
            Trials, Journal of the Royal Statistical Society: Series C, 64, 507-523.

           Lin R. and Yin, G. (2016). Bayesian Optimal Interval Designs for Dose Finding in
           Drug-combination Trials, Statistical Methods in Medical Research, to appear.
}
\seealso{
Tutorial: \url{http://odin.mdacc.tmc.edu/~yyuan/Software/BOIN/BOIN2.2_tutorial.pdf}

          Paper: \url{http://odin.mdacc.tmc.edu/~yyuan/Software/BOIN/paper.pdf}
}

