\name{kruskal}
\alias{kruskal}
\title{Given a weight matrix, generate its maximum weight forest}
\usage{
 kruskal(W)
}
\arguments{
\item{W}{a matrix.}
}
\description{The function lists the edges of an forest generated by Kruskal's algorithm given its weight matrix
in which each weight should be symmetric but may be negative.
The forest is a spanning tree if the elements of the matrix take positive values.  
}
\value{
A matrix object of size n x 2 for matrix size n x n in which each row expresses an edge
when the vertexes are expressed by 1 through n.
}
\author{
Joe Suzuki and Jun Kawahara
}
\references{
[1]  Suzuki. J.  ``The Bayesian Chow-Liu algorithms", In the sixth European workshop on Probabilistic Graphical Models, pp. 315-322, Granada, Spain, Sept.2012.}
\examples{
library(igraph)
library(bnlearn)
df=asia
mi.mat=mi_matrix(df)
edge.list=kruskal(mi.mat)
edge.list
g=graph_from_edgelist(edge.list, directed=FALSE)
V(g)$label=colnames(df)
plot(g)
}
