% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMisc.R
\name{makeDist}
\alias{makeDist}
\title{makeDist}
\usage{
makeDist(x, Fx, sorted = FALSE, rearrange = FALSE)
}
\arguments{
\item{x}{vector of values}

\item{Fx}{vector of the distribution function values}

\item{sorted}{boolean indicating whether or not x is already sorted;
computation is somewhat faster if already sorted}

\item{rearrange}{boolean indicating whether or not should monotize
distribution function}
}
\value{
ecdf
}
\description{
turn vectors of a values and their distribution function values
 into an ecdf.  Vectors should be the same length and both increasing.
}
\examples{
y <- rnorm(100)
y <- y[order(y)]
u <- runif(100)
u <- u[order(u)]
F <- makeDist(y,u)

}
