% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_BLP_dataset.R
\name{simulate_BLP_dataset}
\alias{simulate_BLP_dataset}
\title{This function creates a simulated BLP dataset.}
\usage{
simulate_BLP_dataset(nmkt, nbrn, Xlin, Xexo, Xrandom, instruments,
  true.parameters = list(), price.endogeneity = list(mean.xi = -2,
  mean.eita = 0, cov = cbind(c(1, 0.7), c(0.7, 1))), printlevel = 1,
  seed)
}
\arguments{
\item{nmkt}{number of markets}

\item{nbrn}{number of products}

\item{Xlin}{character vector specifying the set of linear variables}

\item{Xexo}{character vector specifying the set of exogenous variables (subset of \code{Xlin})}

\item{Xrandom}{character vector specifying the set of random coefficients (subset of \code{Xlin})}

\item{instruments}{character vector specifying the set of instrumental variables}

\item{true.parameters}{list with parameters of the DGP
\describe{
\item{\code{Xlin.true.except.price}}{"true" linear coefficients in utility function except price}
\item{\code{Xlin.true.price}}{"true" linear price coefficient in utility function}
\item{\code{Xrandom.true}}{"true" set of random coefficients}
\item{\code{instrument.effects}}{"true" coefficients of instrumental variables to explain endogenous price}
\item{\code{instrument.Xexo.effects}}{"true" coefficients of exogenous variables to explain endogenous price} }}

\item{price.endogeneity}{list with arguments of the multivariate normal
distribution
\describe{
\item{\code{mean.xi}}{controls for the mean of the error term in the utility function}
\item{\code{mean.eita}}{controls for the mean of the error term in the price function}
\item{\code{cov}}{controls for the covariance of \code{xi} and \code{eita} }}}

\item{printlevel}{0 (no output) 1 (summary of generated data)}

\item{seed}{seed for the random number generator}
}
\value{
Returns a simulated BLP dataset.
}
\description{
This function creates a simulated BLP dataset.
}
\details{
The dataset is balanced, so every market has the same amount of products.
 Only unobserved heterogeneity can be considered.
 Variables that enter the equation as a Random Coefficient or
 exogenously must be included in the set of linear variables.
 The \code{parameter.list} argument specifies the "true" effect on the
 individual utility for each component. Prices are generated endogenous
 as a function of exogenous variables and instruments, where the
 respective effect sizes are specified in \code{instrument.effects}
 and \code{instrument.Xexo.effects}. Error terms \code{xi} and \code{eita}
 are drawn from a multivariate normal distribution, whose
 parameters can be set in \code{price.endogeneity}. Market shares
 are generated by MLHS integration rule with 10000 nodes.
}
\examples{
K<-2 #number of random coefficients

}
