% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latlong2UTM.R
\name{latlong2UTM}
\alias{latlong2UTM}
\title{Translate the long lat coordinate in UTM coordinate}
\usage{
latlong2UTM(coord)
}
\arguments{
\item{coord}{Coordinates of the site(s), a matrix/dataframe with two columns (e.g. cbind(longitude, latitude)) (see examples).}
}
\value{
a data frame with :
\itemize{
\item \code{long}: The longitude of the entry
\item \code{lat}: The latitude of the entry
\item \code{codeUTM}: The code \code{proj} for UTM
\item \code{X}: The X UTM coordinate
\item \code{Y}: The Y UTM coordinate
}
}
\description{
Translate the long lat coordinate in UTM coordinate
}
\examples{

long <- c(-52.68, -51.12, -53.11)
lat <- c(4.08, 3.98, 4.12)
coord <- cbind(long, lat)
\donttest{
UTMcoord <- latlong2UTM(coord)
}

}
