% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictOffAxis.R
\name{predictOffAxis}
\alias{predictOffAxis}
\title{Compute off-axis predictions}
\usage{
predictOffAxis(
  data,
  fitResult,
  transforms = fitResult$transforms,
  null_model = c("loewe", "hsa", "bliss", "loewe2"),
  ...
)
}
\arguments{
\item{data}{Dose-response dataframe.}

\item{fitResult}{Monotherapy (on-axis) model fit, e.g. produced by
\code{\link{fitMarginals}}. It has to be a \code{"MarginalFit"} object or a
list containing \code{df}, \code{sigma}, \code{coef},
\code{shared_asymptote} and \code{method} elements for, respectively,
marginal model degrees of freedom, residual standard deviation, named
vector of coefficient estimates, logical value of whether shared asymptote
is imposed and method for estimating marginal models during bootstrapping
(see \code{\link{fitMarginals}}). If biological and power transformations
were used in marginal model estimation, \code{fitResult} should contain
\code{transforms} elements with these transformations. Alternatively, these
can also be specified via \code{transforms} argument.}

\item{transforms}{Transformation functions. If non-null, \code{transforms} is
a list containing 5 elements, namely biological and power transformations
along with their inverse functions and \code{compositeArgs} which is a list
with argument values shared across the 4 functions. See vignette for more
information.}

\item{null_model}{Specified null model for the expected response surface.
Currently, allowed options are \code{"loewe"} for generalized Loewe model,
\code{"hsa"} for Highest Single Agent model, \code{"bliss"} for Bliss additivity,
and \code{"loewe2"} for the alternative Loewe generalization.}

\item{...}{Further arguments that are currently unused}
}
\value{
This functions returns a list with 3 elements.

  \code{"offaxisZTable"} is a dataframe containing dose levels, observed
  effects and effects predicted according to the specified null model. This
  dataframe also contains replicates, if there are any.

  \code{"predSurface"} are the predicted effects (without replicates)
  according to the specified null model. These effects are arranged in a
  matrix form so that each direction of the matrix rightward or downward
  corresponds to increasing dose of one of the compounds.

  \code{"occupancy"} contains occupancy levels at each dose
  combination as (always) computed by generalized Loewe model.
}
\description{
Given a dataframe with dose-response data, this function uses coefficient
estimates from the marginal (on-axis) monotherapy model to compute the
expected values of response at off-axis dose combinations using a provided
null model.
}
\examples{
  data <- subset(directAntivirals, experiment == 1)
  ## Data must contain d1, d2 and effect columns
  transforms <- getTransformations(data)
  fitResult <- fitMarginals(data, transforms)
  predictOffAxis(data, fitResult, null_model = "hsa")
}
