% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.R
\name{related_coef}
\alias{related_coef}
\title{Relatedness Coefficient Calculation}
\usage{
related_coef(generations = 2, path = NULL, full = TRUE)
}
\arguments{
\item{generations}{Specifies the number of generations back of common ancestors the pair share}

\item{path}{A Traditional method to count common ancestry, which is 2 times the number of generations removed from common ancestors}

\item{full}{Full or half kin. Do the kin share both parents at the common ancestor's generation?}
}
\value{
Relatedness Coefficient \code{coef}
}
\description{
Relatedness Coefficient Calculation based on Wright (1922)
}
\details{
\eqn{r_{bc} = \sum \left(\frac{1}{2}\right)^{n+n'+1} (1+f_a)}
where the relatedness coefficient between two people (b & c) is defined in relation to their common ancestors.
}
\examples{

# For two full siblings, we would expect a relatedness of 0.5. Using the
# default method to count common ancestry, and looking back one generation
# (i.e. towards the full siblings' parents), we get a relatedness coefficient
# of 0.5:
related_coef(generations = 1, path = NULL, full = TRUE)
# Similarly, for half siblings, we would expect a relatedness coefficient of 0.25:
related_coef(generations = 1, path = NULL, full = FALSE)
}
