% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{bfs_get_metadata}
\alias{bfs_get_metadata}
\title{Download BFS metadata in a given language}
\usage{
bfs_get_metadata(
  language = "de",
  path = pins::board_cache_path(),
  force = FALSE
)
}
\arguments{
\item{language}{character The language of the metadata.}

\item{path}{Path to local folder to use as a cache, default to {pins} cache.}

\item{force}{Force to download metadata even if already downloaded today.}
}
\value{
A tibble
}
\description{
Returns a tibble containing the titles, publication dates,
observation periods, data source, metadata webpage urls and download link urls 
in a given language of the current public BFS datasets available. If the path of 
the cache argument is not provided, the downloaded BFS dataset will be saved in 
the default cache folder of the {pins} package.
}
\details{
Languages availables are German ("de", as default), French ("fr"),
Italian ("it") and English ("en"). Note that Italian and English BFS
metadata doesn't give access to all the BFS datasets availables online.

The BFS metadata is saved in a local folder using the pins package. The
function allows to download the BFS metadata only once per day in a given
language. If the metadata has alread been downloaded in a given language 
during the day, the existing dataset is loaded into R from the pins caching 
folder instead of downloading again the metadata from the BFS website.
}
\examples{
\donttest{meta_en <- bfs_get_metadata(language = "en")}

}
\seealso{
\code{\link{bfs_get_dataset}}
}
