% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BEIDList.R
\name{focusOnScope.BEIDList}
\alias{focusOnScope.BEIDList}
\title{Convert a BEIDList object in a specific identifier (BEID) scope}
\usage{
\method{focusOnScope}{BEIDList}(
  x,
  be,
  source,
  organism,
  scope = NULL,
  force = FALSE,
  restricted = TRUE,
  prefFilter = TRUE,
  ...
)
}
\arguments{
\item{x}{the BEIDList to be converted}

\item{be}{the type of biological entity to focus on.
Used if \code{is.null(scope)}}

\item{source}{the source of BEID to focus on.
Used if \code{is.null(scope)}}

\item{organism}{the organism of BEID to focus on.
Used if \code{is.null(scope)}}

\item{scope}{a list with the following element:
\itemize{
\item \strong{be}
\item \strong{source}
\item \strong{organism}
}}

\item{force}{if TRUE the conversion is done even between identical scopes
(default: FALSE)}

\item{restricted}{if TRUE (default) the BEID are limited to current version
of the source}

\item{prefFilter}{if TRUE (default) the BEID are limited to prefered
identifiers when they exist}

\item{...}{additional parameters to the BEID conversion function}
}
\value{
A BEIDList
}
\description{
Convert a BEIDList object in a specific identifier (BEID) scope
}
