% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Size.2levFr.R
\name{Size.2levFr}
\alias{Size.2levFr}
\title{Sample size calculator for 2 level fractional factorial design}
\usage{
Size.2levFr(factor,fraction,order,delta_type,delta,alpha,beta)
}
\arguments{
\item{factor}{the number of factor}

\item{fraction}{the number of generators p ex) \eqn{2^(k-p)}}

\item{order}{building the model with main or including the interaction effects ;
1 : only main effects(default) , 2 : both main and two-way interaction effects}

\item{delta_type}{type of standardized effect size ; 1 : standard deviation type(default), 2 : range of effect type}

\item{delta}{lists of effects size; The first and the second column is effect size of main and two-way interaction effects, respectively. The third column is standard devitaion of noise.}

\item{alpha}{Type I error ; 0.05 (default)}

\item{beta}{Type II error ; 0.20 (default)}
}
\value{
model, optimal sample size and detectable standardized effect sizes

        Detectable standardized effect sizes return only one or two values for main and two-way interaction effects.
}
\description{
Sample size in 2 level fractional factorial design is computed in order to detect a certain standardized effect size "delta" with power "1-beta" at the significance level "alpha".
The model for fractional factorial design contains only main effects in resolution III and IV.
}
\examples{
#only main effects
A<-Size.2levFr(factor=3, fraction=1,order=1,
delta_type=1, delta=c(1,0,1), alpha=0.05, beta=0.2)
A$model
A$n
A$Delta

#including two-way interaction effects
B<-Size.2levFr(factor=5, fraction=1,order=2,
delta_type=1, delta=c(1,1,1), alpha=0.05, beta=0.2)

}
\references{
Lenth,R.V., 2006-9. Java Applets for Power and Sample Size[Computer software]. Retrieved March 27, 2018 from http://www.stat.uiowa.edu/~rlenth/Power

Lim, Yong Bin, 1998. Study on the Size of Minimal Standardized Detectable Difference in Balanced Design of Experiments, \emph{Journal of the Korean society for Quality Management}, 26(4),239-249.

Marvin, A., Kastenbaum, A. and Hoel, D.G., 1970. Sample size requirements : one-way analysis of variance, \emph{Biometrika} 57(2),421-430.
}
