% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{prediction}
\alias{prediction}
\title{Prediction}
\usage{
prediction(input_data, depth, train_size, beta = NULL)
}
\arguments{
\item{input_data}{the sequence to be analysed. 
The sequence needs to be a "character" object. See the examples section on how to transform any dataset to a "character" object.}

\item{depth}{maximum memory length.}

\item{train_size}{number of samples used for training.}

\item{beta}{hyper-parameter of the model prior. 
Takes values between 0 and 1. If not initialised in the call function, the default value is \ifelse{html}{\out{1-2<sup>-m+1</sup>}}{\eqn{1 - 2^{-m+1}}}, 
where \ifelse{html}{\out{m}}{\eqn{m}} is the size of the alphabet; for more information see: \href{https://arxiv.org/pdf/2007.14900.pdf}{Kontoyiannis et al. (2020)}.}
}
\value{
returns a "list" containing the posterior predictive distribution at each time step. The last entry in the list, named "Prediction", contains the most likely character 
at each time step according to the posterior predictive distribution.
}
\description{
Computes the posterior predictive distribution at each time step, and predicts the next symbol as its most likely value. Given an initial context
\ifelse{html}{\out{(x<sub>-D+1</sub>, ..., x<sub>0</sub>)}}{\eqn{(x_{-D+1},...,x_0)}} and training data \ifelse{html}{\out{(x<sub>1</sub>, ..., x<sub>n</sub>)}}{\eqn{(x_{1},...,x_n)}}, the posterior predictive distribution is computed sequentially for the test data \ifelse{html}{\out{(x<sub>n+1</sub>, ..., x<sub>n+T</sub>)}}{\eqn{(x_{n+1},...,x_{n+T})}}. The function outputs the predicted distribution at each time step, along with the most likely symbol; for more information see \href{https://arxiv.org/pdf/2007.14900.pdf}{Kontoyiannis et al.(2020)}.
}
\examples{
# Predicting the 2 last characters of a dataset using a model with a maximum depth of 5
# The training size is the total number of characters within the dataset minus 2: nchar(pewee) - 2

q <- prediction(pewee, 5, nchar(pewee) - 2)

q
# [[1]]
# [1] 0.56300039 0.05899728 0.37800233

# [[2]]
# [1] 0.08150306 0.76293065 0.15556628

# $Prediction
# [1] "0" "1"

# To access the "Prediction" from result list q:
q[["Prediction"]]

# For custom beta (e.g. 0.8):
prediction(pewee, 5, nchar(pewee) - 10, 0.8)
}
\seealso{
\code{\link{log_loss}}, \code{\link{zero_one_loss}}
}
