\name{find.mle_FPK}
\alias{find.mle_FPK}
\title{
Maximum-likelihood estimation}
\description{
Find the maximum-likelihood estimate of the FPK model.}
\usage{
find.mle_FPK(model, method = "Nelder-Mead", init.optim = NULL, safe = F)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{model}{
An FPK or BBMV model, as generated by \link{lnL_FPK} or \link{lnL_BBMV}.}
  \item{method}{
The optimization routine to be used: can be either "Nelder-Mead" (the default) or "L-BFGS-B". See the documentation of the \link[stats]{optim} function for more details. From our experience, "Nelder-Mead" seems to produce better results.
}
  \item{init.optim}{
A vector of initial values for model parameters to start the optimization algorithm. If left NULL (as is by default), the function chooses a reasonable starting point, but you might want to play around with it.}
  \item{safe}{
If safe is set to TRUE, the function runs three different optimizations starting with different values of the rate of evolution (sigma). This can prove useful in difficult cases. Default to FALSE for a single optimization (which is quicker).}
}

\value{
A list with the following elements:
  \item{lnL }{the log-likelihood of the model}
  \item{aic }{the Akaike Information Criterion of the model}
  \item{k }{the number of parameters of the model}
  \item{par }{a list of the MLEs of model parameters}
  \item{par_fixed }{a list with the parameters that were fixed. This includes the bounds use to discretize the model and eventually some of the parameters describing the shape of the macroevolutionary landscape.}
  \item{root }{A table giving the probability density of the trait at the root of the tree. The first column gives all possible trait values on the discretized trait grid, and the second the probability density at each of these points.} 
  \item{convergence }{Convergence code returned by optim. 0 indicates successful convergence. For other values see the help of the \link[stats]{optim} function.}
  \item{message }{Convergence message returned by optim. See the help of the \link[stats]{optim} function.}
  \item{tree }{the tree used as input}  
  \item{trait }{the trait vector used as input}
  \item{Npts }{the number of points used to discretize trait space.}
}
\author{
F. C. Boucher
}
\examples{
\dontrun{
# Simulate data: tree + continuous trait
library(geiger)
tree=sim.bdtree(stop='taxa',n=10) # tree with few tips for quick tests
tree$edge.length=100*tree$edge.length/max(branching.times(tree)) # rescale the tree 
# Simulate trait evolving on a macroevolutionary landscape with two peaks of equal heights
x=seq(from=-1.5,to=1.5,length.out=100)
bounds=c(min(x),max(x)) # the bounds we use for simulating
# they are just here for technical purposes but are not reached
V6=10*(x^4-0.5*(x^2)+0.*x) # this is the evolutionary potential: it has two wells
TRAIT= Sim_FPK(tree,x0=0,V=V6,sigma=10,bounds=c(-5, 5)) 
# fit the FPK model: 
ll_FPK4=lnL_FPK(tree,TRAIT,Npts=25,a=NULL,b=NULL,c=NULL) # the full model
fit4=find.mle_FPK(model=ll_FPK4)
}
}
