% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_aks_methods.R
\name{list_kubernetes_versions}
\alias{list_kubernetes_versions}
\title{List available Kubernetes versions}
\description{
Method for the \link[AzureRMR:az_subscription]{AzureRMR::az_subscription} and \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} classes.
}
\section{Usage}{
\preformatted{## R6 method for class 'az_subscription'
list_kubernetes_versions(location)

## R6 method for class 'az_resource_group'
list_kubernetes_versions()
}
}

\section{Arguments}{

\itemize{
\item \code{location}: For the az_subscription class method, the location for which to obtain available Kubernetes versions.
}
}

\section{Value}{

A vector of strings, which are the Kubernetes versions that can be used when creating a cluster.
}

\examples{
\dontrun{

rg <- AzureRMR::get_azure_login()$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

rg$list_kubernetes_versions()

}
}
\seealso{
\link{create_aks}

\href{https://kubernetes.io/docs/reference/}{Kubernetes reference}
}
