% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_aci_methods.R
\name{create_aci}
\alias{create_aci}
\title{Create Azure Container Instance (ACI)}
\description{
Method for the \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} class.
}
\section{Usage}{
\preformatted{create_aci(name, location = self$location,
           container = name, image,
           registry_creds = list(),
           cores = 1, memory = 8,
           os = c("Linux", "Windows"),
           command = list(), env_vars = list(),
           ports = aci_ports(), dns_name = name, public_ip = TRUE,
           restart = c("Always", "OnFailure", "Never"), managed_identity = TRUE,
           ...)
}
}

\section{Arguments}{

\itemize{
\item \code{name}: The name of the ACI service.
\item \code{location}: The location/region in which to create the ACI service. Defaults to this resource group's location.
\item \code{container}: The name of the running container.
\item \code{image}: The name of the image to run.
\item \code{registry_creds}: Docker registry authentication credentials, if the image is stored in a private registry. See 'Details'.
\item \code{cores}: The number of CPU cores for the instance.
\item \code{memory}: The memory size in GB for the instance.
\item \code{os}: The operating system to run in the instance.
\item \code{command}: A list of commands to run in the instance.
\item \code{env_vars}: A list of name-value pairs to set as environment variables in the instance.
\item \code{ports}: The network ports to open. By default, opens ports 80 and 443. See 'Details'.
\item \code{dns_name}: The domain name prefix for the instance. Only takes effect if \code{public_ip=TRUE}.
\item \code{public_ip}: Whether the instance should be publicly accessible.
\item \code{restart}: Whether to restart the instance should an event occur.
\item \code{managed_identity}: Whether to assign the container instance a managed identity.
\item \code{...}: Other named arguments to pass to the \link{az_resource} initialization function.
}
}

\section{Details}{

An ACI resource is a running container hosted in Azure. See the \href{https://docs.microsoft.com/en-us/azure/container-instances/}{documentation for the resource} for more information. Currently ACI only supports a single image in an instance.

To supply the registry authentication credentials, the \code{registry_creds} argument should contain either an \link[=acr]{ACR} object, a \link{docker_registry} object, or the result of a call to the \link{aci_creds} function.

The ports to open should be obtained by calling the \link{aci_ports} function. This takes a vector of port numbers as well as the protocol (TCP or UDP) for each port.
}

\section{Value}{

An object of class \code{az_container_instance} representing the instance.
}

\examples{
\dontrun{

rg <- AzureRMR::get_azure_login()$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

# get the ACR resource that contains the image
myacr <- rg$get_acr("myregistry", as_admin=TRUE)

rg$create_aci("mycontainer",
    image="myregistry.azurecr.io/myimage:latest",
    registry_creds=myacr)

}
}
\seealso{
\link{get_aci}, \link{delete_aci}, \link{list_acis}

\link{az_container_instance}

\href{https://docs.microsoft.com/en-us/azure/container-instances/}{ACI documentation} and
\href{https://docs.microsoft.com/en-us/rest/api/container-instances/}{API reference}

\href{https://docs.docker.com/engine/reference/commandline/cli/}{Docker commandline reference}
}
