% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChileClimateData.R
\name{ChileClimateData}
\alias{ChileClimateData}
\title{Title ChileClimateData}
\source{
<http://www.meteochile.gob.cl/>
}
\usage{
ChileClimateData(Estaciones = "INFO", Parametros, inicio, fin, Region = FALSE)
}
\arguments{
\item{Estaciones}{data vector containing the  codes of the monitoring
stations. To see the table with the monitoring stations use ChileClimateData()}

\item{Parametros}{data vector containing the names of the climate parameters.
Available parameters: "Temperatura", "PuntoRocio", "Humedad","Viento", "PresionQFE", "PresionQFF".}

\item{inicio}{text string containing the start year of the data request.}

\item{fin}{text string containing the end year of the data request.}

\item{Region}{logical parameter. If region is true it allows to enter the administrative region in which the station is located instead of the station code.}
}
\value{
A data frame with climate data of Chile.
}
\description{
function that compiles climate data from Climate direction of Chile (D.M.C.)
}
\examples{

try({ChileClimateData()}, silent = TRUE)

try({
head(ChileClimateData(Estaciones = "180005",
 Parametros = c("Temperatura", "Humedad"),
  inicio = "2020", fin = "2020"))
}, silent = TRUE)

try({
head(ChileClimateData(Estaciones = "II",
 Parametros = "Temperatura", inicio = "2020",
  fin = "2020", Region = TRUE))
}, silent = TRUE)
}
