% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CredibleInterval.R
\name{CredibleInterval}
\alias{CredibleInterval}
\title{Bayesian credible interval}
\usage{
CredibleInterval(a_chain, level = 0.95, roundingOfValue = 0)
}
\arguments{
\item{a_chain}{Numeric vector containing the output of the MCMC algorithm
for the parameter.}

\item{level}{Probability corresponding to the level of confidence used for the
credible interval, default = 0.95.}

\item{roundingOfValue}{Integer indicating the number of decimal places to be used, default = 0.}
}
\value{
A named vector of values containing the confidence level and the endpoints of the shortest
credible interval in calendar years (BC/AD).
}
\description{
Computes the shortest credible interval of the output of the MCMC algorithm for a single parameter
}
\details{
A \eqn{(100 * level)}\\% credible interval is an interval that keeps \eqn{N * (1 - level)}
elements of the sample outside the interval.
The \eqn{(100 * level)}\\% credible interval is the shortest of all those intervals.
}
\examples{
  data(Events); attach(Events)
  CredibleInterval(Event.1)
  CredibleInterval(Event.12, 0.50)

}
