% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParam.R
\name{SimParam_addSnpChip}
\alias{SimParam_addSnpChip}
\title{Add SNP chip}
\arguments{
\item{nSnpPerChr}{number of SNPs per chromosome. 
Can be a single value or nChr values.}

\item{minSnpFreq}{minimum allowable frequency for SNP loci.
If NULL, no minimum frequency is used.}

\item{refPop}{reference population for calculating SNP 
frequency. If NULL, the founder population is used.}
}
\description{
Randomly assigns eligble SNPs to a SNP chip
}
\section{Usage}{
 SP$addSnpChip(nSnpPerChr, minSnpFreq = NULL, refPop = NULL)
}

\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addSnpChip(10)

}
