% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pullGeno.R
\name{pullSegSiteGeno}
\alias{pullSegSiteGeno}
\title{Pull seg site genotypes}
\usage{
pullSegSiteGeno(pop, chr = NULL, simParam = NULL)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}} or
\code{\link{RawPop-class}}}

\item{chr}{a vector of chromosomes to retrieve. If NULL,
all chromosome are retrieved.}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
Returns a matrix of genotypes
}
\description{
Retrieves genotype data for all segregating sites
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)
SP$addSnpChip(5)

#Create population
pop = newPop(founderPop, simParam=SP)
pullSegSiteGeno(pop, simParam=SP)

}
