% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{DGP}
\alias{DGP}
\title{Data Generating Process}
\usage{
DGP(
  n,
  snps,
  beta = c(0, 1, 2),
  binary = FALSE,
  include_residual = TRUE,
  indicator = FALSE,
  maf_range = c(0.005, 0.01),
  method = "none",
  random_signs = FALSE,
  weights = c(0, 1, 2)
)
}
\arguments{
\item{n}{Sample size.}

\item{snps}{Number of SNP in the gene.}

\item{beta}{If method = "none", a (3 x 1) coefficient vector for bmvs, dmvs,
and ptvs respectively. If method != "none", a scalar effect size.}

\item{binary}{Generate binary phenotype? Default: FALSE.}

\item{include_residual}{Include residual? If FALSE, returns the expected
value. Intended for testing.}

\item{indicator}{Convert raw counts to indicators? Default: FALSE.}

\item{maf_range}{Range of minor allele frequencies: c(MIN, MAX).}

\item{method}{Genotype aggregation method. Default: "none".}

\item{random_signs}{Randomize signs? FALSE for burden-type genetic
architecture, TRUE for SKAT-type.}

\item{weights}{Aggregation weights.}
}
\value{
List containing: genotypes, annotations, covariates, phenotypes.
}
\description{
Generate a data set consisting of: \itemize{
\item{"anno"}{A SNP-length annotation vector.}
\item{"covar"}{A subject by 6 covariate matrix.}
\item{"geno"}{A subject by SNP genotype matrix.}
\item{"pheno"}{A subject-length phenotype vector.}
}
}
\examples{
# Generate data.
data <- DGP(n = 100, snps = 20)

# View components.
table(data$anno)
head(data$covar)
head(data$geno[, 1:5])
hist(data$pheno)
}
