% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confinterval_function.R
\name{confinterval}
\alias{confinterval}
\title{Utils: Interval of confidence for groups}
\usage{
confinterval(resp, group, alpha = 0.95, type = "upper")
}
\arguments{
\item{resp}{numeric vector with responses}

\item{group}{vector with groups or list with two factors}

\item{alpha}{confidence level of the interval}

\item{type}{lower or upper range}
}
\value{
returns a numeric vector with confidence interval grouped by treatment.
}
\description{
Calculates confidence interval for groups
}
\examples{

#===================================
# One factor
#===================================

dados=rnorm(100,10,1)
trat=rep(paste("T",1:10),10)
confinterval(dados,trat)

#===================================
# Two factor
#===================================
f1=rep(c("A","B"),e=50)
f2=rep(paste("T",1:5),e=10,2)
confinterval(dados,list(f1,f2))
}
