% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSUBDIC_function.R
\name{PSUBDIC}
\alias{PSUBDIC}
\title{Analysis: DIC experiments in split-plot}
\usage{
PSUBDIC(
  f1,
  f2,
  block,
  response,
  norm = "sw",
  homog = "bt",
  alpha.f = 0.05,
  alpha.t = 0.05,
  quali = c(TRUE, TRUE),
  mcomp = "tukey",
  grau = c(NA, NA),
  grau12 = NA,
  grau21 = NA,
  transf = 1,
  constant = 0,
  geom = "bar",
  theme = theme_classic(),
  ylab = "Response",
  xlab = "",
  xlab.factor = c("F1", "F2"),
  fill = "lightblue",
  angle = 0,
  family = "sans",
  color = "rainbow",
  legend = "Legend",
  errorbar = TRUE,
  addmean = TRUE,
  textsize = 12,
  labelsize = 4,
  dec = 3,
  ylim = NA,
  posi = "right",
  point = "mean_se",
  angle.label = 0
)
}
\arguments{
\item{f1}{Numeric or complex vector with plot levels}

\item{f2}{Numeric or complex vector with subplot levels}

\item{block}{Numeric or complex vector with blocks}

\item{response}{Numeric vector with responses}

\item{norm}{Error normality test (\emph{default} is Shapiro-Wilk)}

\item{homog}{Homogeneity test of variances (\emph{default} is Bartlett)}

\item{alpha.f}{Level of significance of the F test (\emph{default} is 0.05)}

\item{alpha.t}{Significance level of the multiple comparison test (\emph{default} is 0.05)}

\item{quali}{Defines whether the factor is quantitative or qualitative (\emph{qualitative})}

\item{mcomp}{Multiple comparison test (Tukey (\emph{default}), LSD, Scott-Knott and Duncan)}

\item{grau}{Polynomial degree in case of quantitative factor (\emph{default} is 1). Provide a vector with three elements.}

\item{grau12}{Polynomial degree in case of quantitative factor (\emph{default} is 1). Provide a vector with n levels of factor 2, in the case of interaction f1 x f2 and qualitative factor 2 and quantitative factor 1.}

\item{grau21}{Polynomial degree in case of quantitative factor (\emph{default} is 1). Provide a vector with n levels of factor 1, in the case of interaction f1 x f2 and qualitative factor 1 and quantitative factor 2.}

\item{transf}{Applies data transformation (default is 1; for log consider 0)}

\item{constant}{Add a constant for transformation (enter value)}

\item{geom}{Graph type (columns or segments (For simple effect only))}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{Treatments name (Accepts the \emph{expression}() function)}

\item{xlab.factor}{Provide a vector with two observations referring to the x-axis name of factors 1 and 2, respectively, when there is an isolated effect of the factors. This argument uses `parse`.}

\item{fill}{Defines chart color (to generate different colors for different treatments, define fill = "trat")}

\item{angle}{x-axis scale text rotation}

\item{family}{Font family (\emph{default} is sans)}

\item{color}{When the columns are different colors (Set fill-in argument as "trat")}

\item{legend}{Legend title name}

\item{errorbar}{Plot the standard deviation bar on the graph (In the case of a segment and column graph) - \emph{default} is TRUE}

\item{addmean}{Plot the average value on the graph (\emph{default} is TRUE)}

\item{textsize}{Font size (\emph{default} is 12)}

\item{labelsize}{Label size (\emph{default} is 4)}

\item{dec}{Number of cells (\emph{default} is 3)}

\item{ylim}{y-axis limit}

\item{posi}{Legend position}

\item{point}{Point type for regression ("mean_se","mean_sd","mean" or "all")}

\item{angle.label}{Label angle}
}
\value{
The table of analysis of variance, the test of normality of errors (Shapiro-Wilk, Lilliefors, Anderson-Darling, Cramer-von Mises, Pearson and Shapiro-Francia), the test of homogeneity of variances (Bartlett), the test of multiple comparisons (Tukey, LSD, Scott-Knott or Duncan) or adjustment of regression models up to grade 3 polynomial, in the case of quantitative treatments. The column chart for qualitative treatments is also returned. The function also returns a standardized residual plot.
}
\description{
Analysis of an experiment conducted in a completely randomized design in a split-plot scheme using fixed effects analysis of variance.
}
\note{
The order of the chart follows the alphabetical pattern. Please use `scale_x_discrete` from package ggplot2, `limits` argument to reorder x-axis. The bars of the column and segment graphs are standard deviation.

In the final output when transformation (transf argument) is different from 1, the columns resp and respo in the mean test are returned, indicating transformed and non-transformed mean, respectively.
}
\examples{

#===================================
# Example tomate
#===================================
# Obs. Consider that the "tomato" experiment is a completely randomized design.
library(AgroR)
data(tomate)
with(tomate, PSUBDIC(parc, subp, bloco, resp, ylab="Dry mass (g)"))
}
\references{
Principles and procedures of statistics a biometrical approach Steel, Torry and Dickey. Third Edition 1997

Multiple comparisons theory and methods. Departament of statistics the Ohio State University. USA, 1996. Jason C. Hsu. Chapman Hall/CRC.

Practical Nonparametrics Statistics. W.J. Conover, 1999

Ramalho M.A.P., Ferreira D.F., Oliveira A.C. 2000. Experimentacao em Genetica e Melhoramento de Plantas. Editora UFLA.

Scott R.J., Knott M. 1974. A cluster analysis method for grouping mans in the analysis of variance. Biometrics, 30, 507-512.
}
\author{
Gabriel Danilo Shimizu, \email{shimizu@uel.br}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
\keyword{DBC}
