% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin_data.R
\name{bin_data}
\alias{bin_data}
\title{Bin data into longer windows}
\usage{
bin_data(x = x, window = 1, method = c("average", "sum"))
}
\arguments{
\item{x}{\code{vector} of activity data.}

\item{window}{window size used to bin the original 1440 dimensional data into. Window size
should be an integer factor of 1440}

\item{method}{\code{character} of "sum" or "average", function used to bin the data}
}
\value{
a vector of binned data
}
\description{
Bin minute level data into different time resolutions
}
\examples{
data(example_activity_data)
count1 = c(t(example_activity_data$count[1,-c(1,2)]))
xbin = bin_data(x = count1, window = 10, method = "average")
}
