% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_input.R
\name{sort_input}
\alias{sort_input}
\title{Sort custom input}
\usage{
sort_input(BM, fw)
}
\arguments{
\item{BM}{numeric vector, body mass of species.}

\item{fw}{adjacency matrix of the food web.}
}
\value{
A list with sorted body masses (\emph{body.mass}) and food web
  matrix (\emph{food.web}).
}
\description{
Sort custom input
}
\details{
Body masses and food web matrix should be arranged with the first
  elements/columns being for basal species. This is a requirement for the Cpp
  class and must be enforced before initializing the Rcpp_Schneider and
  Rcpp_Delmas objects.
}
\examples{
bm <- runif(10, 10, 50)
fw <- matrix(as.numeric(runif(100) > .9), 10, 10)
sort_input(bm, fw)
}
