% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.dge.single.R
\name{met.dge.single}
\alias{met.dge.single}
\title{Average Dyadic Efficiency}
\usage{
met.dge.single(
  m,
  weighted = TRUE,
  shortest.weight = FALSE,
  normalization = TRUE,
  directed = TRUE
)
}
\arguments{
\item{m}{a square adjacency matrix.}

\item{weighted}{if \emph{true}, it binarizes the square adjacency matrix M. Geodesic distances and diameter are based only on the presence or absence of edges.}

\item{shortest.weight}{if \emph{false}, it considers the higher met.strength as the shortest path.}

\item{normalization}{normalizes the weigths of the links i.e. divides them by the average strength of the network.}

\item{directed}{if \emph{false}, it symmetrizes the matrix. Otherwise, it calculates geodesic distances and diameter according to the directionality of the links.}
}
\value{
An interger representing the average dyadic efficiency.
}
\description{
Calculates the average dyadic efficiency of a network.
}
\details{
The average dyadic efficiency provides a measure of how efficiently information is exchanged in a network. It can be calculated in binary or weighted networks, undirected or directed networks, normalized or not, and through the strongest or the weakest links. Depending on the problematic, care is needed for the choice of calculation method.
}
\references{
Pasquaretta, C., Levé, M., Claidiere, N., Van De Waal, E., Whiten, A., MacIntosh, A. J., ... & Crofoot, M. C. (2014). Social networks in primates: smart and tolerant species have more efficient networks. Scientific reports, 4, 7600.
}
\author{
Sebastian Sosaez
}
\keyword{internal}
