% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.density.R
\name{met.density}
\alias{met.density}
\title{Density}
\usage{
met.density(M, df = NULL)
}
\arguments{
\item{M}{a square adjacency matrix, or a list of square adjacency matrices, or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{df}{a data frame of same length as the input matrix or a list of data frames if argument \emph{M} is a list of matrices or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}
}
\value{
\itemize{
\item a double representing the density of the network if argument \emph{M} is a square matrix.
\item A list of doubles if argument \emph{M} is a list of matrices and if argument \emph{df} is \emph{NULL}. Each double represents the density of the corresponding matrix of the list.
}
}
\description{
Calculates network binary density.
}
\details{
Binary network density is sthe ratio of existing links of a network in relation to all potential links.
}
\examples{
met.density(sim.m)
}
\references{
Sosa, S. (2018). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
