% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear.by.linear.R
\name{linear.by.linear}
\alias{linear.by.linear}
\title{Perform Linear by linear association test}
\usage{
linear.by.linear(
  x,
  y,
  u = NULL,
  v = NULL,
  nsims.mc = 1e+05,
  seed = NULL,
  do.asymp = FALSE,
  do.mc = TRUE
)
}
\arguments{
\item{x}{Factor of same length as y}

\item{y}{Factor of same length as x}

\item{u}{Numeric vector of length equal to number of levels of x or NULL (defaults to \code{NULL})}

\item{v}{Numeric vector of length equal to number of levels of y or NULL (defaults to \code{NULL})}

\item{nsims.mc}{Number of Monte Carlo simulations to be performed (defaults to \code{100000})}

\item{seed}{Random number seed to be used for Monte Carlo simulations (defaults to \code{NULL})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.mc}{Boolean indicating whether or not to perform Monte Carlo calculations (defaults to \code{TRUE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{linear.by.linear()} performs the Linear by linear association test and is used in chapter 13 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 13.8 from "Applied Nonparametric Statistical Methods" (5th edition)
linear.by.linear(ch13$dose, ch13$dose.side.effect, do.mc = FALSE, do.asymp = TRUE)

# Exercise 13.4 from "Applied Nonparametric Statistical Methods" (5th edition)
linear.by.linear(ch13$SBP, ch13$cholesterol, seed = 1)

}
