% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kruskal.wallis.lsd.R
\name{kruskal.wallis.lsd}
\alias{kruskal.wallis.lsd}
\title{Perform Least Significant Differences test after the Kruskal-Wallis test}
\usage{
kruskal.wallis.lsd(x, g, ids)
}
\arguments{
\item{x}{Numeric vector of same length as g}

\item{g}{Factor of same length as x}

\item{ids}{Vector of length 2 with elements both levels of g}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{kruskal.wallis.lsd()} performs the Least Significant Differences test after the Kruskal-Wallis test and is used in chapter 8 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 8.10 from "Applied Nonparametric Statistical Methods" (5th edition)
kruskal.wallis.lsd(ch8$sentences, ch8$authors, c("Vulliamy", "Queen"))

# Exercise 8.8 from "Applied Nonparametric Statistical Methods" (5th edition)
kruskal.wallis.lsd(ch8$seizure.score, ch8$hospital, c("HospitalA", "HospitalC"))

}
