% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\docType{data}
\name{chapter_3_table_3}
\alias{chapter_3_table_3}
\alias{C3T3}
\alias{Chapter_3_Table_3}
\alias{c3t3}
\title{The data used in Chapter 3, Table 3}
\format{An object of class \code{data.frame} with 30 rows and 2 columns.}
\source{
\url{https://designingexperiments.com/data/}

Maxwell, S. E., Delaney, H. D., & Kelley, K. (forthcoming). \emph{Designing experiments and 
analyzing data: {A} model comparison perspective}. (3rd ed.). Routledge.
}
\usage{
data(chapter_3_table_3)
}
\description{
The data used in Chapter 3, Table 3.
}
\details{
Although different mood states have, of course, always been of interest to clinicians, recent years have seen a profusion of studies attempting to manipulate mood states in controlled laboratory studies. In such induced-mood research, participants typically are randomly assigned to one of three groups: a depressed-mood induction, a neutral-mood induction, or an elated-mood induction. One study (Pruitt, 1988) used selected videoslips from several movies and public television programs as the mood-induction treatments. After viewing the video for her assigned condition, each participant was asked to indicate her mood on various scales. In addition, each subject was herself videotaped, and her facial expressions of emotion were rated on a scale of 1 to 7 (1 indicating sad; 4, neutral; and 7, happy) by an assistant who viewed the videotapes but was kept "blind" regarding the subjects' assigned conditions.
}
\section{Variables}{

\describe{
 \item{cond}{assigned Condition: a numeric vector (1=Pleasant/elated, 2=Neutral, 3=Unpleasant/depressed)}
 \item{mood}{a numeric vector between 1 and 7}}
}

\section{Synonym}{

C3T3
}

\examples{
# Load the data
data(chapter_3_table_3)

# Or, alternatively load the data as
data(C3T3)

# View the structure
str(chapter_3_table_3)

}
\references{
Maxwell, S. E., Delaney, H. D., \& Kelley, K. (forthcoming). \emph{Designing experiments and analyzing data: 
{A} model comparison perspective} (3rd ed.). Routledge.
}
\author{
Ken Kelley \email{kkelley@nd.edu}
}
\keyword{datasets}
