% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expandAmatrix.R
\name{expandAmatrix}
\alias{expandAmatrix}
\title{Add new crosses to a current A matrix}
\usage{
expandAmatrix(newPedigree = NULL, A = NULL, returnAll = TRUE)
}
\arguments{
\item{newPedigree}{pedigree data name (3-column way format). Unknown value should be equal 0.}

\item{A}{numerator relationship matrix output from Amatrix function.}

\item{returnAll}{if TRUE returns old A with new A, if FALSE returns only new A}
}
\value{
Matrix with the Relationship between the individuals.
}
\description{
Expand a current A matrix with a new pedigree. The parents in the new pedigree should also be in the A matrix.
}
\examples{
data(ped.sol)
ped.initial = ped.sol[1:1120,]
ped.new = ped.sol[-c(1:1120),]
#Computing additive relationship matrix:
A = Amatrix(ped.initial, ploidy=2)
Anew = expandAmatrix(ped.new, A)

#Comparing with one-step building..
Afull = Amatrix(ped.sol, ploidy=2)
test = Anew-Afull
which(test!=0)

}
\author{
Rodrigo R Amadeu, \email{rramadeu@gmail.com}
}
