% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acep_clean.R
\name{acep_clean}
\alias{acep_clean}
\title{Limpieza de texto.}
\usage{
acep_clean(
  x,
  tolower = TRUE,
  rm_cesp = TRUE,
  rm_emoji = TRUE,
  rm_hashtag = TRUE,
  rm_users = TRUE,
  rm_punt = TRUE,
  rm_num = TRUE,
  rm_url = TRUE,
  rm_meses = TRUE,
  rm_dias = TRUE,
  rm_stopwords = TRUE,
  rm_shortwords = TRUE,
  rm_newline = TRUE,
  rm_whitespace = TRUE,
  other_sw = NULL,
  u = 1
)
}
\arguments{
\item{x}{vector de textos al que se le aplica la
función de limpieza de texto.}

\item{tolower}{convierte los textos a minúsculas.}

\item{rm_cesp}{remueve caracteres especiales.}

\item{rm_emoji}{remueve los emojis.}

\item{rm_hashtag}{remueve los hashtags.}

\item{rm_users}{remueve las menciones de usuarixs de redes sociales.}

\item{rm_punt}{remueve la puntuación.}

\item{rm_num}{remueve números.}

\item{rm_url}{remueve las url.}

\item{rm_meses}{remueve los meses del año.}

\item{rm_dias}{remueve los días de la semana.}

\item{rm_stopwords}{remueve palabras vacías.}

\item{rm_shortwords}{remueve las palabras cortas.}

\item{rm_newline}{remueve los saltos de línea.}

\item{rm_whitespace}{remueve los espacios en blanco.}

\item{other_sw}{su valor por defecto es NULL, sirve para ampliar el
listado de stopwords con un nuevo vector de palabras.}

\item{u}{umbral de caracteres para la función rm_shortwords.}
}
\description{
Función que limpia y normaliza las notas/textos.
}
\examples{
rev_puerto <- acep_bases$rev_puerto
rev_puerto$titulo_limpio <- acep_clean(rev_puerto$titulo)
rev_puerto |> head()
}
\keyword{normalización}
