% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{combine_cols}
\alias{combine_cols}
\title{Combine columns}
\usage{
combine_cols(data, col_1, col_2, name = NULL, keep_other = TRUE)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{col_1}{character. The name of the first variable/column.}

\item{col_2}{character. The name of the second variable/column.}

\item{name}{character. The name of the field with the combined data.
By default, \code{name = NULL}, the combined data field is named the same
as \code{col_1}.}

\item{keep_other}{logical. Whether to combine the combined column with the
input data frame (Default: TRUE).}
}
\value{
tbl. The input data frame with the combined column and the second
column removed. The name of the combined column is the same as \code{col_1},
or user-specified in the \code{name} argument.
}
\description{
Combines two columns into one. The name of the first column is used for the
new column, the second  column is removed. Used for cases where different
versions of the same variable exist that have to be combined before computing
a summary score.
}
\examples{
data <- tibble::tibble(
  var_id = c("A", "B", "C"),
  var_orig = c(1, NA, 3),
  var_alt = c(NA, 2, 4)
)

data |>
  combine_cols(
    col_1 = "var_orig",
    col_2 = "var_alt"
  )

data |>
  combine_cols(
    "var_orig",
    "var_alt",
    name = "out"
  )

data |>
  combine_cols(
    "var_orig",
    "var_alt",
    name = "out",
    keep_other = FALSE
  )

}
