% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_basic.R
\name{report_basic}
\alias{report_basic}
\title{report on transport efficiency}
\usage{
report_basic(df, params, dist)
}
\arguments{
\item{df}{is the particle data set (data frame) established with the
`particle_dist` function}

\item{params}{is the parameter data set for parameters that are not
particle size-dependent}

\item{dist}{selects the distribution for the report. Options are
'discrete' for discrete particle sizes or 'log' for the log-normal
distribution of particles that were started with the `particle_dist`
function.}
}
\value{
report of system efficiency
}
\description{
In order to run a report, first produce a model of each individual
element. Start with producing a particle distribution
with the `particle_dist` function, then produce a parameter set with
the `set_params` function. Both of these results must be stored as
per examples described in the help set with each. Next, add elements
in the sample system until all are complete.
}
\examples{
df <- particle_dist() # set up particle distribution
params <- set_params_1("D_tube" = 2.54, "Q_lpm" = 100,
"T_C" = 25, "P_kPa" = 101.325) #example system parameters
df <- set_params_2(df, params) #particle size-dependent parameters
df <- probe_eff(df, params, orient = 'h') #probe orientation - horizontal
df <- bend_eff(df, params, method='Zhang', bend_angle=90,
bend_radius=0.1, elnum=3)
df <- tube_eff(df, params, L = 100,
angle_to_horiz = 90, elnum = 3)
report_basic(df, params, dist = 'discrete')

}
