#![cfg(any(feature = "std", feature = "libm"))]

use core::ops::Neg;

use crate::{Float, Num, NumCast};











pub trait Real: Num + Copy + NumCast + PartialOrd + Neg<Output = Self> {










    fn min_value() -> Self;











    fn min_positive_value() -> Self;
















    fn epsilon() -> Self;










    fn max_value() -> Self;












    fn floor(self) -> Self;












    fn ceil(self) -> Self;













    fn round(self) -> Self;












    fn trunc(self) -> Self;














    fn fract(self) -> Self;



















    fn abs(self) -> Self;


















    fn signum(self) -> Self;

















    fn is_sign_positive(self) -> bool;

















    fn is_sign_negative(self) -> bool;



















    fn mul_add(self, a: Self, b: Self) -> Self;











    fn recip(self) -> Self;













    fn powi(self, n: i32) -> Self;











    fn powf(self, n: Self) -> Self;




















    fn sqrt(self) -> Self;















    fn exp(self) -> Self;













    fn exp2(self) -> Self;



















    fn ln(self) -> Self;






















    fn log(self, base: Self) -> Self;

















    fn log2(self) -> Self;


















    fn log10(self) -> Self;












    fn to_degrees(self) -> Self;












    fn to_radians(self) -> Self;











    fn max(self, other: Self) -> Self;











    fn min(self, other: Self) -> Self;


















    fn abs_sub(self, other: Self) -> Self;













    fn cbrt(self) -> Self;















    fn hypot(self, other: Self) -> Self;













    fn sin(self) -> Self;













    fn cos(self) -> Self;












    fn tan(self) -> Self;





















    fn asin(self) -> Self;





















    fn acos(self) -> Self;














    fn atan(self) -> Self;




























    fn atan2(self, other: Self) -> Self;

















    fn sin_cos(self) -> (Self, Self);














    fn exp_m1(self) -> Self;




















    fn ln_1p(self) -> Self;

















    fn sinh(self) -> Self;

















    fn cosh(self) -> Self;

















    fn tanh(self) -> Self;













    fn asinh(self) -> Self;













    fn acosh(self) -> Self;














    fn atanh(self) -> Self;
}

impl<T: Float> Real for T {
    forward! {
        Float::min_value() -> Self;
        Float::min_positive_value() -> Self;
        Float::epsilon() -> Self;
        Float::max_value() -> Self;
    }
    forward! {
        Float::floor(self) -> Self;
        Float::ceil(self) -> Self;
        Float::round(self) -> Self;
        Float::trunc(self) -> Self;
        Float::fract(self) -> Self;
        Float::abs(self) -> Self;
        Float::signum(self) -> Self;
        Float::is_sign_positive(self) -> bool;
        Float::is_sign_negative(self) -> bool;
        Float::mul_add(self, a: Self, b: Self) -> Self;
        Float::recip(self) -> Self;
        Float::powi(self, n: i32) -> Self;
        Float::powf(self, n: Self) -> Self;
        Float::sqrt(self) -> Self;
        Float::exp(self) -> Self;
        Float::exp2(self) -> Self;
        Float::ln(self) -> Self;
        Float::log(self, base: Self) -> Self;
        Float::log2(self) -> Self;
        Float::log10(self) -> Self;
        Float::to_degrees(self) -> Self;
        Float::to_radians(self) -> Self;
        Float::max(self, other: Self) -> Self;
        Float::min(self, other: Self) -> Self;
        Float::abs_sub(self, other: Self) -> Self;
        Float::cbrt(self) -> Self;
        Float::hypot(self, other: Self) -> Self;
        Float::sin(self) -> Self;
        Float::cos(self) -> Self;
        Float::tan(self) -> Self;
        Float::asin(self) -> Self;
        Float::acos(self) -> Self;
        Float::atan(self) -> Self;
        Float::atan2(self, other: Self) -> Self;
        Float::sin_cos(self) -> (Self, Self);
        Float::exp_m1(self) -> Self;
        Float::ln_1p(self) -> Self;
        Float::sinh(self) -> Self;
        Float::cosh(self) -> Self;
        Float::tanh(self) -> Self;
        Float::asinh(self) -> Self;
        Float::acosh(self) -> Self;
        Float::atanh(self) -> Self;
    }
}
