






use crate::free::put_back;
use crate::structs::PutBack;





pub enum Diff<I, J>
    where I: Iterator,
          J: Iterator
{


    FirstMismatch(usize, PutBack<I>, PutBack<J>),

    Shorter(usize, PutBack<I>),

    Longer(usize, PutBack<J>),
}













pub fn diff_with<I, J, F>(i: I, j: J, is_equal: F)
    -> Option<Diff<I::IntoIter, J::IntoIter>>
    where I: IntoIterator,
          J: IntoIterator,
          F: Fn(&I::Item, &J::Item) -> bool
{
    let mut i = i.into_iter();
    let mut j = j.into_iter();
    let mut idx = 0;
    while let Some(i_elem) = i.next() {
        match j.next() {
            None => return Some(Diff::Shorter(idx, put_back(i).with_value(i_elem))),
            Some(j_elem) => if !is_equal(&i_elem, &j_elem) {
                let remaining_i = put_back(i).with_value(i_elem);
                let remaining_j = put_back(j).with_value(j_elem);
                return Some(Diff::FirstMismatch(idx, remaining_i, remaining_j));
            },
        }
        idx += 1;
    }
    j.next().map(|j_elem| Diff::Longer(idx, put_back(j).with_value(j_elem)))
}
