% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge}
\alias{cbind.zoocat}
\alias{merge}
\alias{merge.zoocat}
\title{Combine \code{zoocat} or \code{zoomly} Objects by Columns}
\usage{
\method{merge}{zoocat}(..., all = TRUE, fill = NA, suffixes = NULL,
  check.names = FALSE, retclass = "zoocat", drop = TRUE)

cbind.zoocat(...)
}
\arguments{
\item{...}{\code{zoocat} or \code{zoomly} objects.}

\item{all, fill, suffixes, check.names, retclass, drop}{See details.}
}
\value{
\code{merge.zoocat} will return a "\code{zoocat}" object.
 \code{merge.zoomly} will return a "\code{zoomly}" object.
}
\description{
Combine "\code{zoocat}" or "\code{zoomly}" objects by columns.
}
\details{
\code{merge.zoocat} and \code{merge.zoomly} are the extensions of \code{merge.zoo}.
For \code{merge.zoocat}, when combining \code{cattr}, some NA will be filled in if it is
necessary. \cr
The arguments \code{all} and \code{fill} are used same as in \code{merge.zoo}.
The arguments \code{suffixes}, \code{check.names}, \code{retclass} 
and \code{drop} are not used.
}
\examples{

x1 <- matrix(1 : 20, nrow = 5)
colAttr <- data.frame(month = c(2, 3, 5, 6), name = 'xxx')
zc1 <- zoocat(x1, order.by = 1991 : 1995, colattr = colAttr)
x2 <- x1 + 100
colAttr2 <- data.frame(modified = TRUE, month = c(4, 6, 7, 9))
zc2 <- zoocat(x2, order.by = 1991 : 1995, colattr = colAttr2)
merge(zc1, zc2)
merge(zc1, lag(zc2), fill = -999)
merge(zc1, lag(zc2), all = FALSE)
cbind(zc1, zc2)

}

