% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_users.R
\name{get_users}
\alias{get_users}
\title{Returns All Available Zendesk Users.}
\usage{
get_users(email_id, token, subdomain, start_time, user_role = "all")
}
\arguments{
\item{email_id}{Zendesk Email Id (username).}

\item{token}{Zendesk API token.}

\item{subdomain}{Your organization's Zendesk sub-domain.}

\item{start_time}{String with a date or datetime to get all
tickets modified after that date.}

\item{user_role}{User role, one of "all", "end-user", "agent", or "admin".}
}
\value{
Data Frame with user details
}
\description{
It takes your Email Id, authentication token,
sub-domain and parse all the users in a list.
It iterates through all the pages returning only 100 users per
page until the "next_page" parameter becomes null indicating
there are no more pages to fetch.
}
\details{
It's not a good practice to write down these authentication
parameters in your code. There are various methods and
packages available that are more secure; this package
doesn't require you to use any one in particular.

The start_page parameter is useful if you have many users. Each
page contains 100 users. Zendesk does not have an incremental
method for pulling users by date but after you retrieve all of
your users once, you can then increment your start page to
something that will limit the number of users you are
re-pulling each time.

If you are pulling partial lists of users be aware that you
will not get updates on older users. You will only get recently
created users, not modified/deleted users and their modified
data nor updated last login dates.
}
\examples{
\dontrun{
users <- get_users(email_id, token, subdomain)
}
}
\references{
\url{https://developer.zendesk.com/rest_api
/docs/support/users}
}
