% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zb_stats.R
\name{zb_stats}
\alias{zb_stats}
\alias{zb_stats_}
\title{Get statistics on Zoobank activity}
\usage{
zb_stats(start_date, end_date, period = "day", parse = TRUE, ...)

zb_stats_(start_date, end_date, period, ...)
}
\arguments{
\item{start_date}{(date/character) a start date}

\item{end_date}{(date/character) an end date}

\item{period}{(character) the period. Default: day}

\item{parse}{(logical) Whether to parse to list (\code{FALSE}) or
data.frame (\code{TRUE}). If \code{TRUE}, we also give back a
tibble for easier consumption. Default: \code{TRUE}}

\item{...}{Curl options passed to \code{\link[crul]{HttpClient}}}
}
\description{
Get statistics on Zoobank activity
}
\examples{
\dontrun{
zb_stats(start_date = "2018-03-01", end_date = "2018-04-01")
zb_stats(start_date = "2018-03-01", end_date = "2018-04-01", 
 parse = FALSE)
}
}
