% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bowlerDeliveryWickets.R
\name{bowlerDeliveryWickets}
\alias{bowlerDeliveryWickets}
\title{Number of deliveries to wickets}
\usage{
bowlerDeliveryWickets(match,theTeam,name)
}
\arguments{
\item{match}{Data frame of the match}

\item{theTeam}{The team for which the delivery wickets have to be computed}

\item{name}{The name of the bowler}
}
\value{
dataframe
}
\description{
This function creates a dataframe of balls bowled versus the wickets taken by
the bowler
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
#Get match data
match <- getMatchDetails("England","Pakistan","2006-09-05",dir="../data")
bowlerDeliveryWickets(match,"India","Jadeja")
}

}
\references{
\url{https://cricsheet.org/}\cr
\url{https://gigadom.in/}\cr
\url{https://github.com/tvganesh/yorkrData}
}
\seealso{
\code{\link{batsmanFoursSixes}}\cr
\code{\link{batsmanRunsVsDeliveries}}\cr
\code{\link{batsmanRunsVsStrikeRate}}\cr
\code{\link{bowlerDeliveryWickets}}\cr
\code{\link{bowlerMeanEconomyRate}}\cr
\code{\link{bowlerMeanRunsConceded}}\cr
}
\author{
Tinniam V Ganesh
}
