% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mimic.R
\name{mimic.default}
\alias{mimic.default}
\title{Try To Look Like Another Equal-length Variable}
\usage{
\method{mimic}{default}(x, y = x, ...)
}
\arguments{
\item{x}{vector-like}

\item{y}{vector-like, same length as x}

\item{...}{ignored arguments}
}
\value{
same class as x
}
\description{
Tries to mimic another vector or factor.
If meaningful and possible, x acquires
a guide attribute with labels from
corresponding values in y. Any codelist
attribute is removed. No guide is created
for zero-length x.
}
\examples{
example(mimic.classified)

}
\seealso{
Other mimic: 
\code{\link{mimic.classified}()},
\code{\link{mimic}()}

Other interface: 
\code{\link{classified.data.frame}()},
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{desolve.decorated}()},
\code{\link{ggplot.decorated}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res.character}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{is_parseable.default}()},
\code{\link{modify.default}()},
\code{\link{promote.default}()},
\code{\link{read_yamlet}()},
\code{\link{resolve.decorated}()},
\code{\link{selected.default}()},
\code{\link{write_yamlet}()}
}
\concept{interface}
\concept{mimic}
