% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{redecorate}
\alias{redecorate}
\title{Redecorate a List-like Object}
\usage{
redecorate(x, ..., overwrite = TRUE)
}
\arguments{
\item{x}{object}

\item{...}{passed arguments}

\item{overwrite}{passed to \code{\link{decorate}}}
}
\value{
a list-like object, typically data.frame
}
\description{
Redecorates a list-like object.
Equivalent to \code{decorate( ..., overwrite = TRUE)}.
}
\examples{
library(dplyr)
library(magrittr)
library(csv)
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
x <- decorate(as.csv(file))
x \%>\% select(Subject) \%>\% as_yamlet
x \%<>\% redecorate('Subject: Patient Identifier')
x \%>\% select(Subject) \%>\% as_yamlet

}
\seealso{
Other decorate: 
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{decorate.list}()},
\code{\link{decorate}()},
\code{\link{decorations.data.frame}()},
\code{\link{decorations}()}
}
\concept{decorate}
