% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explicit_guide.R
\name{explicit_guide.data.frame}
\alias{explicit_guide.data.frame}
\title{Coerce Data Frame Guide to Something More Explicit}
\usage{
\method{explicit_guide}{data.frame}(x, overwrite = TRUE, ...)
}
\arguments{
\item{x}{yamlet}

\item{overwrite}{passed as TRUE}

\item{...}{passed to \code{\link{as_yamlet}}, \code{\link{explicit_guide}}, and \code{\link{decorate}}}
}
\value{
yamlet
}
\description{
Coerces data.frame 'guide' attributes to something more explicit.
The attribute 'guide' generally suggests a guide
to interpretation of a data item, such as units, formats, codelists,
and encodings.  The idea here is to replace 'guide' with something
explicit in case required downstream.
}
\details{
This method pulls the 'decorations' off of the data.frame,
converts to yamlet, applies \code{\link{explicit_guide.yamlet}},
purges 'guide' attributes from the data.frame,
and then re-decorates using \code{overwrite = TRUE}.
}
\examples{
library(magrittr)
x <- data.frame(
 ID = 1,
 CONC = 1,
 RACE = 1,
 SEX = 1,
 DATE = 1
)
x$ID   \%<>\% structure(label = 'subject identifier')
x$CONC \%<>\% structure(label = 'concentration', guide = 'ng/mL')
x$RACE \%<>\% structure(label = 'race', guide = list(white = 0, black = 1, asian = 2))
x$SEX  \%<>\% structure(label = 'sex', guide = list(female = 0, male = 1))
x$DATE \%<>\% structure(label = 'date', guide = '\%Y-\%m-\%d')
x \%>\% as_yamlet
x \%>\% explicit_guide \%>\% as_yamlet
}
\seealso{
Other explicit_guide: 
\code{\link{explicit_guide.yamlet}()},
\code{\link{explicit_guide}()}
}
\concept{explicit_guide}
\keyword{internal}
