% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explicit_guide.R
\name{explicit_guide.yamlet}
\alias{explicit_guide.yamlet}
\title{Coerce Yamlet Guide to Something More Explicit}
\usage{
\method{explicit_guide}{yamlet}(x, default = "units", data = NULL, ...)
}
\arguments{
\item{x}{yamlet}

\item{default}{length-one character: the default key}

\item{data}{optional data.frame for testing guides with length > 1}

\item{...}{ignored arguments}
}
\value{
yamlet
}
\description{
Coerces yamlet 'guide' keys to something more explicit.
The key 'guide' generally suggests a guide
to interpretation of a data item, such as units, formats, codelists,
and encodings.  The idea here is to replace 'guide' with something
explicit in case required downstream.
}
\details{
The logic is as follows.  If value of 'guide' is of length greater than
one (and data is not supplied), it is assumed to be a 'codelist'
(and this value replaces 'guide').
If, however, it is (\code{\link[encode]{encoded}}), the valued becomes
'encoding'. Failing those tests, two or more percent signs will flag
it as a 'format' string, i.e. for a date or time class. Otherwise
'guide' will be replaced with 'units' by default.

If \code{data} is supplied, guides with length greater than one
are checked to see if they evaluate to conditions in data context.
If so, inferences are based on the first guide element rather
than the guide as a whole.
}
\examples{
library(magrittr)
'CONC: [ concentration, ng/mL ]' \%>\% as_yamlet \%>\% explicit_guide
'RACE: [ subject race, [ Caucasian, Latin, Black ]]' \%>\% as_yamlet \%>\% explicit_guide
'RACE: [ subject race, //Caucasian//Latin//Black// ]' \%>\% as_yamlet \%>\% explicit_guide
'DATE: [ date, "\%Y-\%m-\%d" ]' \%>\% as_yamlet \%>\% explicit_guide
}
\seealso{
Other explicit_guide: 
\code{\link{explicit_guide.data.frame}()},
\code{\link{explicit_guide}()}
}
\concept{explicit_guide}
\keyword{internal}
