% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/winsteps.R
\name{winsteps}
\alias{winsteps}
\title{Interface to Winsteps}
\usage{
winsteps(u, codes = c(0, 1), noprint = TRUE, ws.path = "C:/Winsteps/",
  prefix = paste("wstmp", as.integer(Sys.Date()), sep = ""), peo.mean = 0,
  item.mean = NULL, scale = 1, peo.anchor = NULL, item.anchor = NULL,
  out.vars = NULL)
}
\arguments{
\item{u}{a reponse matrix}

\item{codes}{a vector of valid response values}

\item{noprint}{TRUE to remove temporary files}

\item{ws.path}{the winstep installation directory}

\item{prefix}{a prefix attached to temporarily generated files}

\item{peo.mean}{the mean of centered person parameters}

\item{item.mean}{the mean of centered item parameters}

\item{scale}{the sd of centering variable}

\item{peo.anchor}{a two-column matrix of anchored person values: index, value}

\item{item.anchor}{a two-column maxtrix of anchored item values: index, value}

\item{out.vars}{a vector of variables to be extracted from winstep outputs}
}
\value{
a list of theta, b, step parameters
}
\description{
Run a winsteps calibration in R
}
\details{
Winsteps is a commerical software pacakge that calibrates Rach-family models.
See Winsteps Manual for more detail regarding its syntax and functionality.
}
\examples{
\dontrun{
u <- gen.rsp(gen.irt(200, 20, a.mu=log(.5882), a.sig=0, c.min=0, c.max=0))
winsteps(u$rsp)
}
}

