% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/side_effects.R
\name{capture_parse_eval_side_effects}
\alias{capture_parse_eval_side_effects}
\title{Capture side effects from parse eval}
\usage{
capture_parse_eval_side_effects(string, envir = NULL)
}
\arguments{
\item{string}{String of code that can be parsed and evaluated in \code{envir}.}

\item{envir}{Environment to evaluate in. Defaults to
\code{\link[base:parent.frame]{parent.frame()}}.}
}
\value{
Named list with the side effects.
}
\description{
Wraps string in \code{\link[xpectr:capture_side_effects]{capture_side_effects()}}
before parsing and evaluating it.
The side effects (error, warnings, messages) are returned in a list.

When capturing an error, no other side effects are captured.
}
\examples{
# Attach package
library(xpectr)

\donttest{
capture_parse_eval_side_effects("stop('hi!')")
capture_parse_eval_side_effects("warning('hi!')")
capture_parse_eval_side_effects("message('hi!')")
}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
